// $Id: errors.cpp,v 1.1 2002/03/26 04:47:02 ccf7f Exp $
// Flancrest Enterprises, Group 22

#include "stdafx.h"
#include "errors.h"
#include "iostream"
using namespace std;

Errors *errors;

Errors::Errors(const bool consoleWindow)
{
	const string fnName = "Errors";
	errors = NULL;

	printMutex = CreateMutex(NULL, FALSE,  "ErrorsPrintMutex");
	if(NULL == printMutex) {
		cerr << "Unable to create mutex printMutex" << endl;
		cerr << "GetLastError(): " << GetLastError() << endl;
		exit(-1);
	}

	if(consoleWindow) {
		if(AllocConsole()) {
			freopen("CONIN$", "rb", stdin);
			freopen("CONOUT$","wb", stdout);
			freopen("CONOUT$","wb", stderr);
			cout << "FANG - FlANcrest client Gui\nDebugging Console"
				<< endl << endl;
			errors = this;
		}
		else
			Error("CFangApp", fnName,
			"Unable to open a console window, continuing without a console.");
	}
}

Errors::~Errors()
{
	FreeConsole();
}

void Errors::Error(const string Class, const string fn, const string errorMsg)
{
	// TODO: this should popup a window for the user instead of displaying
	// to the console.
	// Maybe *also* log to the console, but at least tell the user graphically.
	WaitForSingleObject(printMutex, INFINITE);
	cout << "ERROR| " << Class << "::" << fn << "(): " << errorMsg << endl;
	if(!ReleaseMutex(printMutex)) {
		cerr << "ERROR* Errors::Error: Couldn't release printMutex" << endl;
	}
}

void Errors::Debug(const string Class, const string fn, const string debugMsg)
{
	WaitForSingleObject(printMutex, INFINITE);
	cout << "DEBUG| " << Class << "::" << fn << "(): " << debugMsg << endl;
	if(!ReleaseMutex(printMutex)) {
		cerr << "ERROR* Errors::Debug: Couldn't release printMutex" << endl;
	}
}

void fangError(const string Class, const string fn, const string errorMsg)
{
	if(NULL != errors)
		errors->Error(Class, fn, errorMsg);
}

void fangDebug(const string Class, const string fn, const string debugMsg)
{
	if(NULL != errors)
		errors->Debug(Class, fn, debugMsg);
}