// $Id: errors.h,v 1.3 2002/03/27 02:28:28 ccf7f Exp $
// Flancrest Enterprises, Group 22
// About this file:
// The Error class hides the method of informing the user of errors
// and debugging information.

// Use of the global functions, fangError and fangDebug, is prefered
// to using the Errors class instance member functions, but identical.


#ifndef ERRORS_H
#define ERRORS_H

#include <string>
using namespace std;

class Errors
{
public:
	// Set consoleWindow to true if we should open a console window	
	Errors(const bool consoleWindow);
	~Errors();
	// See the argument decriptions below
	void Error(const string Class, const string fn, const string errorMsg);
	void Debug(const string Class, const string fn, const string errorMsg);
private:
	HANDLE printMutex;
};

// fangError() and fangDebug() arguments:
// class is the name of the class, fn is the name of the function, and
// (error|debug)Msg is the actual message.
//
// User will be notified via gui
void fangError(const string Class, const string fn, const string errorMsg);

// Messages will be shown to the user only if in debugging mode
void fangDebug(const string Class, const string fn, const string debugMsg);

#endif
