// $Id: fang.cpp,v 1.1 2002/03/26 04:47:02 ccf7f Exp $
// Flancrest Enterprises, Group 22
// About this file:
// Defines the class behaviors for the application.

#include "stdafx.h"
#include "fang.h"
#include "fangDlg.h"
#include "errors.h"
#include "robot.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFangApp

BEGIN_MESSAGE_MAP(CFangApp, CWinApp)
	//{{AFX_MSG_MAP(CFangApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFangApp construction

CFangApp::CFangApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CFangApp object

const bool consoleWindow = true;
CFangApp theApp;


#include "cmd.h"
void robotTest(Robot &robot)
{
	robot.connect("cs-tl3.cs.virginia.edu");
	string command = "vm";
	vector<string> args;
	args.push_back("12");
	args.push_back("24");
	Cmd cmd(command, args);
	robot.tell(cmd);
	
	command = "heartBeat";
	args.erase(args.begin(), args.end());
	Cmd cmd2(command, args);
	robot.tell(cmd2);

	Sleep(10000);
	robot.disconnect();
}

/////////////////////////////////////////////////////////////////////////////
// CFangApp initialization

BOOL CFangApp::InitInstance()
{
	const string fnName = "InitInstance";

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	Errors errors(consoleWindow);

	Robot robot;
	CFangDlg dlg;
	robot.setGui(&dlg);
	dlg.setRobot(&robot);

//	robotTest(robot);

	m_pMainWnd = &dlg;
	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}
