// $Id: fangDlg.cpp,v 1.1 2002/03/26 04:47:02 ccf7f Exp $
// Flancrest Enterprises, Group 22

#include "stdafx.h"
#include "fang.h"
#include "fangDlg.h"
#include "cmd.h"
#include "robot.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFangDlg dialog

CFangDlg::CFangDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFangDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFangDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFangDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFangDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFangDlg, CDialog)
	//{{AFX_MSG_MAP(CFangDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_LEFT, OnButtonLeft)
	ON_BN_CLICKED(IDC_BUTTON_FORWARD, OnButtonForward)
	ON_BN_CLICKED(IDC_BUTTON_RIGHT, OnButtonRight)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_CAM_RIGHT, OnButtonCamRight)
	ON_BN_CLICKED(IDC_BUTTON_CAM_UP, OnButtonCamUp)
	ON_BN_CLICKED(IDC_BUTTON_CAM_DOWN, OnButtonCamDown)
	ON_BN_CLICKED(IDC_BUTTON_CAM_LEFT, OnButtonCamLeft)
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, OnButtonConnect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFangDlg message handlers

BOOL CFangDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	setup();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFangDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFangDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFangDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

bool CFangDlg::setRobot(Robot *robot)
{
	this->robot = robot; 
	return true;
}

void CFangDlg::update(Cmd command)
{
	vector<string> args = command.getArgs();
	string cmd = command.getCommand();
	if(cmd == "heartBeat"){
		if(args[0] == "Good"){
			heartbeat = true;
			SetDlgItemText(IDC_STATIC_HEARTBEAT,"Receiving Heartbeat");
		}
		else if(args[0] == "Lost"){
			heartbeat = false;
			SetDlgItemText(IDC_STATIC_HEARTBEAT,"Heartbeat Lost");
			MessageBox("Warning: Heartbeat Lost", "Warning");
		}
		else;
	}

}

/*
void CFangDlg::receiveMoveButtons(buttonsData buttons)
{
}

void CFangDlg::receiveCameraSliders(slidersData sliders)
{
}

void CFangDlg::receiveConnect(string hostname)
{
}

void CFangDlg::receiveStatusInfo(statusInfo status)
{
}

void CFangDlg::receiveScriptButtons(buttonsData buttons)
{
}
*/

void CFangDlg::setup()
{

}

void CFangDlg::OnButtonLeft() 
{
	string commandName = "rotateRobot";
	vector<string> args;
	string turnDegreesArg = "-150";
	args.push_back(turnDegreesArg);
	Cmd command(commandName, args);
	robot->tell(command);
}

void CFangDlg::OnButtonForward() 
{
	//sets wheel speeds
	string commandName = "sp";
	vector<string> args;
	string rightWheelSpeedArg = "10";
	string leftWheelSpeedArg = "10";
	args.push_back(rightWheelSpeedArg);
	args.push_back(leftWheelSpeedArg);
	Cmd command(commandName, args);
	robot->tell(command);
	//tells robot to move forward 10 inches
	string commandName2 = "pr";
	vector<string> args2;
	string rightWheelStepArg = "10";
	string leftWheelStepArg = "10";
	args2.push_back(rightWheelStepArg);
	args2.push_back(leftWheelStepArg);
	Cmd command2(commandName2, args2);
	robot->tell(command2);
}

void CFangDlg::OnButtonRight() 
{
	string commandName = "rotateRobot";
	vector<string> args;
	string turnDegreesArg = "150";
	args.push_back(turnDegreesArg);
	Cmd command(commandName, args);
	robot->tell(command);
}

void CFangDlg::OnButtonStop() 
{
	string commandName = "st";
	vector<string> args;
	string robotArg = "1";
	string cameraArg = "0";
	args.push_back(robotArg);
	args.push_back(cameraArg);
	Cmd command(commandName, args);
	robot->tell(command);
}

void CFangDlg::OnButtonCamRight() 
{
	string commandName = "bumpCamera";
	vector<string> args;
	string panDistanceArg = "150";
	string tiltDistanceArg = "0";
	string panSpeedArg = "150";
	string tiltSpeedArg = "150";
	args.push_back(panDistanceArg);
	args.push_back(tiltDistanceArg);
	args.push_back(panSpeedArg);
	args.push_back(tiltSpeedArg);
	Cmd command(commandName, args);
	robot->tell(command);
}

void CFangDlg::OnButtonCamUp() 
{
	string commandName = "bumpCamera";
	vector<string> args;
	string panDistanceArg = "0";
	string tiltDistanceArg = "150";
	string panSpeedArg = "150";
	string tiltSpeedArg = "150";
	args.push_back(panDistanceArg);
	args.push_back(tiltDistanceArg);
	args.push_back(panSpeedArg);
	args.push_back(tiltSpeedArg);
	Cmd command(commandName, args);
	robot->tell(command);
}

void CFangDlg::OnButtonCamDown() 
{
	string commandName = "bumpCamera";
	vector<string> args;
	string panDistanceArg = "0";
	string tiltDistanceArg = "-150";
	string panSpeedArg = "150";
	string tiltSpeedArg = "150";
	args.push_back(panDistanceArg);
	args.push_back(tiltDistanceArg);
	args.push_back(panSpeedArg);
	args.push_back(tiltSpeedArg);
	Cmd command(commandName, args);
	robot->tell(command);
}

void CFangDlg::OnButtonCamLeft() 
{
	string commandName = "bumpCamera";
	vector<string> args;
	string panDistanceArg = "-150";
	string tiltDistanceArg = "0";
	string panSpeedArg = "150";
	string tiltSpeedArg = "150";
	args.push_back(panDistanceArg);
	args.push_back(tiltDistanceArg);
	args.push_back(panSpeedArg);
	args.push_back(tiltSpeedArg);
	Cmd command(commandName, args);
	robot->tell(command);
}

void CFangDlg::OnButtonConnect() 
{
	CString text;
	GetDlgItemText(IDC_BUTTON_CONNECT, text);
	if(text == "Connect"){
		GetDlgItemText(IDC_EDIT_SERVER_NAME, text);
		if(robot->connect(string(text)))
			SetDlgItemText(IDC_BUTTON_CONNECT,"Disconnect");
		else
			MessageBox("Failed to connect to Remote Host", "Connection Error");
	}
	else{
		robot->disconnect();
		SetDlgItemText(IDC_BUTTON_CONNECT,"Connect");
		SetDlgItemText(IDC_STATIC_HEARTBEAT,"Not Connected");
		}
}
