// $Id: fangDlg.h,v 1.3 2002/03/27 02:28:28 ccf7f Exp $
// Flancrest Enterprises, Group 22
// About this file:
// This class hides the particular way that Cmds are handled, as well
// as the visual user interface's implementation.

#if !defined(AFX_FANGDLG_H__BE51AAE4_63A8_4C63_B4D5_77E48D74057D__INCLUDED_)
#define AFX_FANGDLG_H__BE51AAE4_63A8_4C63_B4D5_77E48D74057D__INCLUDED_

#include "script.h"
#include "cmd.h"
#include "vjoystick.h"

#include "resource.h"		// main symbols

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CFangDlg dialog

class Robot;

class CFangDlg : public CDialog
{
// Construction
public:
	CFangDlg(CWnd* pParent = NULL);	// standard constructor
	// associates an instance of the robot class with this class
	bool setRobot(Robot *robot);
	// updates the status information member variables and displays them
	// visually.  command is a Cmd containing the update information.
	void update(Cmd command);

// Dialog Data
	//{{AFX_DATA(CFangDlg)
	enum { IDD = IDD_FANG_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFangDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

private:
	// provides potential initialization not included in constructor
	void setup ();

	// Associations
	VJoystick *vjoystick;
	Script *script;
	Robot *robot;

	vector<int> sonar_data;
	vector<bool> bumper_data;
	int battery;
	int camera_pan;
	int camera_tilt;
	int speed;
	bool robot_busy;
	bool camera_busy;
	vector<Script> scripts;
	bool connected;
	bool heartbeat;
	VJoystick joystick;

	// Generated message map functions
	//{{AFX_MSG(CFangDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnButtonLeft();
	afx_msg void OnButtonForward();
	afx_msg void OnButtonRight();
	afx_msg void OnButtonStop();
	afx_msg void OnButtonCamRight();
	afx_msg void OnButtonCamUp();
	afx_msg void OnButtonCamDown();
	afx_msg void OnButtonCamLeft();
	afx_msg void OnButtonConnect();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FANGDLG_H__BE51AAE4_63A8_4C63_B4D5_77E48D74057D__INCLUDED_)
