// $Id: gui.h,v 1.5 2002/03/04 19:28:06 ccf7f Exp $
// Flancrest Enterprises, Group 22

#ifndef GUI_H
#define GUI_H

#include "script.h"
#include "robot.h"
#include "cmd.h"
#include "vjoystick.h"

//The GUI class hides the response to user inputs and the way robot telemetry 
//is stored.  The GUI class is intended to handle all MFC events coming
//from the user and pass them along to the Robot class as Cmd structures.
class GUI {
  // Associations
   Robot * unnamed;
   VJoystick * unnamed;
   Script * unnamed;
  // Attributes
  private:
		//the vector that stores the data received from the robots sonar 
		//sensors
    vector<int> sonar_data;
		//the vector that stores the data received from the robots bump 
		//sensors
    vector<bool> bumper_data;
		//the charge left in the robot's battery
    int battery;
		//the current pan angle of the camera, in degrees
    int camera_pan;
		//the current tilt angle of the camera, in degrees
	int camera_tilt;
		//the current speed setting of the robot
    int speed;
		//indicates if the robot is performing an action or not
    bool robot_busy;
		//indicates if the camera is performing an action or not
    bool camera_busy;
		//stored scripts (sequences of robot commands)
    vector<Script> scripts;
		//indicates if the program is connected to the remote host
    bool connected;
		//indicates if the remote host is sending heartbeats at the
		// specified intervals
    bool heartbeat;
		//the joystick that accepts user input
    VJoystick joystick;
  // Operations

  public:
	vector<int> getSonar_data();
	void setSonar_data(vector<int> data);
    vector<bool> getBumper_data();
	void setBumper_data(vector<bool> data);
    int getBattery();
	void setBattery(int bat);
    int getCamera_pan();
	void setCamera_pan(int pan);
	int getCamera_tilt();
	void setCamera_tilt(int tilt);
    int getSpeed();
	void setSpeed(int speed);
    bool getRobot_busy();
	void setRobot_busy(bool busy);
    bool getCamera_busy();
	void setCamera_busy(bool busy);
    bool getConnected();
	void setConnected(bool con);
    bool getHeartbeat();
	void setHeartbeat(bool beat);

		//udates a part of the visual interface based on the command received
    void update ( Cmd command );
		//reacts to MFC events that control robot movement
    void receiveMoveButtons ( buttonsData buttons );
		//reacts to MFC events that control camera movement
    void receiveCameraSliders ( slidersData sliders );
		//reacts to MFC events that indicate the user wants to connect to the 
		//remote host
    void receiveConnect ( string hostname );
		//reacts to MFC events about various other parameters (speed, etc)
    void receiveStatusInfo ( statusInfo status );
		//reacts to MFC events that affect scripting
    void receiveScriptButtons ( buttonsData buttons );
  private:
		//called to initialize an instance of the GUI class
    void setup (  );
};

#endif
