// $Id: script.h,v 1.6 2002/03/27 02:28:28 ccf7f Exp $
// Flancrest Enterprises, Group 22
// About this file:
// Script holds a series of command-time pairs.  It can be used to automatically
// generate a series of predefined commands.  It hides the storage and retrieval
// of script files.


#ifndef SCRIPT_H
#define SCRIPT_H

#include <string>
using namespace std;

#include "cmdtimepair.h"

class Script {
// Attributes
private:
	vector<CmdTimePair> commands;
    string name;
	int index;
// Operations
public:
	// adds a CmdTimePair command to the end of the list of current commands
	void add(CmdTimePair command);
	// opens a file named filename that contains a stored list of commands
	bool openFile(string filename);
	// returns the current CmdTimePair and points to the next in the list
	CmdTimePair getNext();
	// makes the first CmdTimePair in the list the current CmdTimePair
	void gotoFront();
	// saves the list of CmdTimePairs to a file with the name filename
	bool saveFile(string filename);
	// returns true if the current CmdTimePair is the last in the list,
	// false otherwise
	bool const isLast();
	// returns true if there are no CmdTimePairs in the list, false otherwise
	bool const isEmpty();
	// empties (erases) the list of CmdTimePairs
	void clear();
};

#endif
